/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogInitTable;
import com.ibm.hwmca.base.logd.LogErrorIdsLogD;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.Iterator;
import java.util.List;

public class SecondaryBlockIDSumBean
extends PanelBean
implements LogErrorIdsLogD {
    private static final String TRACE_MASKT = "XLOGDB2T";
    private static final String TRACE_MASKF = "XLOGDB2F";
    private static final String TRACE_MASKD = "XLOGDB2D";
    private static final FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private static final String SECONDARY_BLOCK_LIST = "SecondaryBlockIDChoice";
    public static final String BUTTON_OK = "OkButton";
    public static final String BUTTON_CANCEL = "CancelButton";
    public static final String SECONDARY_BLOCK_ID_SELECTED = "secondaryBlockIdSelected";
    private transient ItemDescriptor[] m_idEventLogTable;
    private transient ColumnDescriptor[] m_cdEventLogTableStructure;
    private transient int[] m_iEventLogTableSelection;
    private transient String m_sSecondaryBlockIDChoice;
    private transient ValueDescriptor[] m_cdSecondaryBlockIDChoice;
    private List _logSecondaryBlocks;
    private EventLogData _eventLogData;

    public void setEventLogData(EventLogData eventLogData) {
        this._eventLogData = eventLogData;
    }

    public void setLogSecondaryBlocks(List logSecondaryBlocks) {
        this._logSecondaryBlocks = logSecondaryBlocks;
    }

    public ColumnDescriptor[] getEventLogTableRowStructure() {
        return this.m_cdEventLogTableStructure;
    }

    public int getEventLogTableRowStatus() {
        return 3;
    }

    public int getEventLogTableRowCount() {
        return 1;
    }

    public ItemDescriptor[] getEventLogTableRowAt(int index) {
        return this.m_idEventLogTable;
    }

    public void setEventLogTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idEventLogTable = items;
    }

    public int[] getEventLogTableSelection() {
        return this.m_iEventLogTableSelection;
    }

    public void setEventLogTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iEventLogTableSelection = selected;
    }

    public String getSecondaryBlockIDChoice() {
        return this.m_sSecondaryBlockIDChoice;
    }

    public void setSecondaryBlockIDChoice(String s) throws IllegalUserDataException {
        this.m_sSecondaryBlockIDChoice = s;
    }

    public ValueDescriptor[] getSecondaryBlockIDChoiceList() {
        return this.m_cdSecondaryBlockIDChoice;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_cdEventLogTableStructure = new ColumnDescriptor[0];
        this.m_iEventLogTableSelection = new int[0];
        this.m_sSecondaryBlockIDChoice = "";
        this.m_cdSecondaryBlockIDChoice = new ValueDescriptor[this._logSecondaryBlocks.size()];
        this.m_idEventLogTable = EventLogInitTable.setEventTableData(this._eventLogData);
        int j = 0;
        Iterator i = this._logSecondaryBlocks.iterator();
        while (i.hasNext()) {
            LogBlock lBlock = (LogBlock)i.next();
            String secBlockId = HexString.toHex(lBlock.getBlockId(), true).toUpperCase();
            if (j == 0) {
                this.m_sSecondaryBlockIDChoice = secBlockId;
            }
            this.m_cdSecondaryBlockIDChoice[j] = new ValueDescriptor(Integer.toString(j), secBlockId);
            ++j;
        }
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> SecondaryBlockIDSumBean.panelAction()");
        PanelTaskletRequest request = null;
        try {
            String command = evt.getActionCommand();
            Trace.trace(TRACE_MASKF, "command = " + command + " on the panel=" + "SecondaryBlockId");
            request = new PanelTaskletRequest();
            request.setData("event", evt);
            request.setData("panelName", "SecondaryBlockId");
            if (command.equals(BUTTON_OK)) {
                Trace.trace(TRACE_MASKF, "Secondary Block id OK button selected");
                String[] selected = this.userTaskManager.getSelectedElementNames(SECONDARY_BLOCK_LIST);
                if (selected == null || selected.length == 0) {
                    BaseMessageText myMess = new BaseMessageText("LOGSECSEL");
                    LocalizableText lStrTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.secondaryblockId.title");
                    LocalizableText ans = CommonMsgApp.showMessageBox(this.userTaskManager, lStrTitle, myMess, MsgType.INFORMATION_MESSAGE);
                } else {
                    Trace.trace(TRACE_MASKF, "Secondary block id Selected=" + selected[0]);
                    request.setData(SECONDARY_BLOCK_ID_SELECTED, selected[0]);
                    this.postTaskletRequest(request);
                }
            } else {
                this.postTaskletRequest(request);
            }
            Trace.trace(TRACE_MASKT, "<- SecondaryBlockIDSumBean.panelAction()");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Error caught in SecondaryBlockIDSumBean.panelAction() exc = " + e);
            HException he = new HException(e);
            new FrameworkLog(_logInfo, 1299, he).log();
            request.setData("panelError", "terminate");
            this.postTaskletRequest(request);
        }
    }
}

